/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.remote;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class PlantuneApiClient {
    private static final Logger LOG = LoggerFactory.getLogger(PlantuneApiClient.class);
    private final String serverUrl;
    private final URI apiUrl;
    private final String auth;
    private final HttpClient httpClient;

    public PlantuneApiClient(String serverUrl, String username, String password) {
        this.apiUrl = PlantuneApiClient.parseUrl(serverUrl).resolve("api/v2/");
        this.serverUrl = serverUrl;
        this.auth = "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8));
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).version(HttpClient.Version.HTTP_1_1).build();
    }

    private static URI parseUrl(String serverUrl) {
        URI uri;
        try {
            String scheme;
            if (!((String)serverUrl).endsWith("/")) {
                serverUrl = (String)serverUrl + "/";
            }
            if ((scheme = (uri = new URI((String)serverUrl)).getScheme()) == null || !scheme.equals("https") && !scheme.equals("http")) {
                throw new IllegalArgumentException("Invalid server URL - bad scheme");
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid server URL", e);
        }
        return uri;
    }

    private HttpRequest.Builder reqBuilder(String relPath, Multimap<String, String> parameters) {
        URI url = this.apiUrl.resolve(relPath);
        if (!parameters.isEmpty()) {
            Escaper esc = UrlEscapers.urlFormParameterEscaper();
            String query = parameters.entries().stream().map(e -> esc.escape((String)e.getKey()) + "=" + esc.escape((String)e.getValue())).collect(Collectors.joining("&"));
            try {
                url = new URI(url + "?" + query);
            }
            catch (URISyntaxException e2) {
                throw new RuntimeException(e2);
            }
        }
        return HttpRequest.newBuilder().uri(url).timeout(Duration.ofMinutes(1L)).header("Authorization", this.auth);
    }

    private String getStringResponse(HttpRequest request) throws IOException, InterruptedException {
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        int statusCode = response.statusCode();
        if (statusCode < 200 || statusCode >= 300) {
            throw new RuntimeException("Invalid response " + statusCode + ": " + response.body());
        }
        return response.body();
    }

    public List<String> getTables() throws IOException, InterruptedException {
        HttpRequest request = this.reqBuilder("tables", ImmutableListMultimap.of()).GET().build();
        HttpResponse<Stream<String>> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofLines());
        if (response.statusCode() != 200) {
            throw new RuntimeException("Cannot list tables: " + response.body().collect(Collectors.joining("\n")));
        }
        return response.body().toList();
    }

    public void downloadTables(OutputStream to, List<String> tableNames) throws IOException, InterruptedException {
        ImmutableListMultimap<String, String> parameters = Multimaps.index(tableNames, t -> "table");
        HttpRequest request = this.reqBuilder("tables/data", parameters).header("Accept", "application/zip").GET().build();
        LOG.info("Downloading tables from {}", (Object)this.serverUrl);
        HttpResponse<InputStream> res = this.httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
        if (res.statusCode() != 200) {
            InputStream body = res.body();
            try {
                String msg = new String(body.readAllBytes(), StandardCharsets.UTF_8);
                throw new RuntimeException("Cannot download tables: " + msg);
            }
            catch (Throwable throwable) {
                if (body != null) {
                    try {
                        body.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        try (InputStream body = res.body();){
            body.transferTo(to);
        }
        LOG.info("Downloaded tables from {}", (Object)this.serverUrl);
    }

    public byte[] downloadTablesAsBytes(List<String> tableNames) throws IOException, InterruptedException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.downloadTables(out, tableNames);
        return out.toByteArray();
    }

    public String uploadTables(InputStream fromZip, @Nullable String taskToRun) throws IOException, InterruptedException {
        String boundary = UUID.randomUUID().toString();
        ArrayList<HttpRequest.BodyPublisher> bodyParts = new ArrayList<HttpRequest.BodyPublisher>();
        if (taskToRun != null) {
            bodyParts.add(HttpRequest.BodyPublishers.ofString("--" + boundary + "\r\nContent-Disposition: form-data; name=taskToRun\r\nContent-Type: text/plain; charset=UTF-8\r\n\r\n" + taskToRun + "\r\n"));
        }
        bodyParts.add(HttpRequest.BodyPublishers.ofString("--" + boundary + "\r\nContent-Disposition: form-data; name=file; filename=data.zip\r\nContent-Type: application/zip\r\n\r\n"));
        bodyParts.add(HttpRequest.BodyPublishers.ofInputStream(() -> fromZip));
        bodyParts.add(HttpRequest.BodyPublishers.ofString("\r\n"));
        bodyParts.add(HttpRequest.BodyPublishers.ofString("--" + boundary + "--\r\n"));
        HttpRequest request = this.reqBuilder("tables/data", ImmutableListMultimap.of()).header("Content-Type", "multipart/form-data; boundary=" + boundary).POST(HttpRequest.BodyPublishers.concat(bodyParts.toArray(new HttpRequest.BodyPublisher[0]))).build();
        LOG.info("Uploading tables to {}", (Object)this.serverUrl);
        String jobId = this.getStringResponse(request);
        LOG.info("Uploaded tables to {}", (Object)this.serverUrl);
        return jobId;
    }

    /*
     * Exception decompiling
     */
    public String copyTablesFrom(PlantuneApiClient plantune, List<String> tableNames, @Nullable String taskToRun) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String startTask(String taskName) throws IOException, InterruptedException {
        HttpRequest request = this.reqBuilder("tasks/queue", ImmutableListMultimap.of("task", taskName)).POST(HttpRequest.BodyPublishers.noBody()).build();
        LOG.info("Starting task {} on {}", (Object)taskName, (Object)this.serverUrl);
        return this.getStringResponse(request);
    }

    @Nonnull
    public TaskStatus getTaskStatus(String taskId) throws IOException, InterruptedException {
        HttpRequest request = this.reqBuilder("tasks/queue/" + taskId, ImmutableListMultimap.of()).GET().build();
        String statusStr = this.getStringResponse(request);
        try {
            return TaskStatus.valueOf(statusStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Unexpected task state " + statusStr, e);
        }
    }

    public void waitFor(String jobId, Duration timeout) throws IOException, InterruptedException {
        TaskStatus status;
        LOG.info("Waiting for {} to finish on {}", (Object)jobId, (Object)this.serverUrl);
        Instant end = Instant.now().plus(timeout);
        do {
            Thread.sleep(1000L);
            status = this.getTaskStatus(jobId);
            switch (status) {
                case DONE: {
                    LOG.info("Task {} has finished successfully on {}", (Object)jobId, (Object)this.serverUrl);
                    return;
                }
                case FAILED: {
                    throw new RuntimeException("Task " + jobId + " has failed.");
                }
            }
        } while (!Instant.now().isAfter(end));
        throw new RuntimeException("Waiting for task " + jobId + " has timed out. Last known state: " + status);
    }

    public void runTask(String taskName, Duration timeout) throws IOException, InterruptedException {
        String jobId = this.startTask(taskName);
        this.waitFor(jobId, timeout);
    }

    private /* synthetic */ String lambda$copyTablesFrom$4(PipedInputStream pis, String taskToRun) throws Exception {
        return this.uploadTables(pis, taskToRun);
    }

    private static /* synthetic */ Thread lambda$copyTablesFrom$3(Runnable r) {
        return new Thread(r, "PtClientUp");
    }

    public static enum TaskStatus {
        RUNNING,
        QUEUED,
        SCHEDULED,
        DONE,
        FAILED;

    }
}

